#ifndef PGAME_H
#define PGAME_H

#include <peach.h>
#include <vec2.h>

#ifdef __cplusplus
extern "C" {
#endif

// define/enum --------------------------------------------------------------@/
#define SCREEN_X 320
#define SCREEN_Y 240

#define SUBFIELD_X (96)
#define SUBFIELD_Y (SCREEN_Y)

#define FIELD_X (SCREEN_X-SUBFIELD_X)
#define FIELD_Y (SCREEN_Y)

#define SUBFIELD_XPOS (FIELD_X)
#define SUBFIELD_YPOS (0)

#define PLAYER_MAX 2
#define PLAYER_SHAKEDURATION 6
#define PADDLE_SIZEX 70
#define PADDLE_SIZEY 12
#define PADDLE_SPEED 5
#define BALL_SPEED 0x500

#define WAITTIMER_WIN 66
#define WAITTIMER_BALLWAIT 96

#define WIN_FLASHDURATION 18
#define WIN_FLASHAMOUNT 60

enum GAMESTATE {
	GAMESTATE_BALLWAIT,
	GAMESTATE_PLAYING,
	GAMESTATE_WIN,
	GAMESTATE_INVALID = -1
};

// types --------------------------------------------------------------------@/
typedef struct CPlayer {
	int score;
	vec2i pos;
	int playerid;
	int shake_timer;
} CPlayer;

typedef struct CBall {
	vec2i pos,mov;
	int16_t owner;
	int16_t did_finish;
} CBall;

typedef struct PGame {
	CBall ball;
	CPlayer players[PLAYER_MAX];

	int stateID;
	int stateIDNew;
	int wait_timer;
	int flash_timer;

	int time_frame;
	int time_seconds;
	int time_mins;
	int time_frameAbsolute;

	int16_t ball_canMove,ball_canDraw;
	int16_t player_canMove;
	int16_t timer_active;

	int score_wintimer;

	CPeachGraph* gr_fontScore;
	CPeachGraph* gr_fontPuchi;
	CPeachGraph* gr_fieldbg;
} PGame;

// variable -----------------------------------------------------------------@/
extern PGame* gPGame;

// function -----------------------------------------------------------------@/
static inline PGame* pgame_workGet() {
	return gPGame;
}

// base.c
void pgame_start();
void pgame_setup();
void pgame_close();
void pgame_update();
void pgame_draw();

void pgame_ball_reset();
void pgame_ball_update();
void pgame_ball_draw();

void pgame_drawUI();

void pgame_fontPuchi_draw(const char* text, int x, int y);
void pgame_fontScore_draw(const char* text, int x, int y);

// player.c
static inline CPlayer* pgame_playerGet(size_t idx) {
	PEACH_ASSERT(idx < PLAYER_MAX,"pgame_player_get(): idx out of range");
	return &pgame_workGet()->players[idx];
}
void pgame_player_updateAll();
void pgame_player_drawAll();
void pgame_player_setup();

#ifdef __cplusplus
}
#endif

#endif

