#include <peach.h>
#include <SDL2/SDL_image.h>

// local function -----------------------------------------------------------@/
static CPeachGraph* peach_graph_findUnused() {
	auto work = peach_workGet();
	for(int i=0; i<PEACH_GRAPH_MAX; i++) {
		auto gr = &work->table_graph[i];
		if(!gr->basersrc.alive) {
			return gr;
		}
	}

	return NULL;
}

// function -----------------------------------------------------------------@/
CPeachGraph* peach_graph_loadFile(const char* filename) {
	auto work = peach_workGet();
	// find free graph resource from table --------------@/
	auto gr = peach_graph_findUnused();
	PEACH_ASSERT(gr,"no free graph!");

	// load graph from file -----------------------------@/
	SDL_Texture* texture_hnd = IMG_LoadTexture(work->renderer_hnd,filename);
	PEACH_ASSERT(texture_hnd,"unable to load file");
	
	gr->texture_hnd = texture_hnd;
	
	// get graph information (width&height) -------------@/
	int width,height;
	SDL_QueryTexture(texture_hnd,NULL,NULL,&width,&height);
	gr->size_x = width;
	gr->size_y = height;

	gr->basersrc.alive = true;
	return gr;
}
void peach_graph_close(CPeachGraph* gr) {
	PEACH_ASSERT(gr,"null graph!")
	PEACH_ASSERT(gr->basersrc.alive,"graph already closed!")

	SDL_DestroyTexture(gr->texture_hnd);
	gr->texture_hnd = NULL;
	gr->basersrc.alive = false;
}
void peach_graph_drawPart(CPeachGraph* gr, int sx, int sy, int sw, int sh, int dx, int dy, int flip) {
	PEACH_ASSERT(gr,"null graph!")
	PEACH_ASSERT(gr->basersrc.alive,"graph dead!")

	auto work = peach_workGet();

	const auto state = peach_drawstateGet();
	const SDL_Rect srcrect = {
		.x = sx, .y = sy,
		.w = sw, .h = sh
	};
	const SDL_Rect dstrect = {
		.x = dx + state->trans_x,
		.y = dy + state->trans_y,
		.w = sw, .h = sh
	};
	SDL_RenderCopyEx(work->renderer_hnd,
		gr->texture_hnd,
		&srcrect,&dstrect,
		0,NULL,flip
	);
}
void peach_graph_draw(CPeachGraph* gr, int x, int y, int flip) {
	PEACH_ASSERT(gr,"null graph!")
	PEACH_ASSERT(gr->basersrc.alive,"graph dead!")

	auto work = peach_workGet();

	const auto state = peach_drawstateGet();
	const SDL_Rect dstrect = {
		.x = x + state->trans_x,
		.y = y + state->trans_y,
		.w = gr->size_x,
		.h = gr->size_y
	};
	SDL_RenderCopyEx(work->renderer_hnd,
		gr->texture_hnd,
		NULL,&dstrect,
		0,NULL,flip
	);
}

