#include <peach.h>

typedef struct CKeymapEntry {
	int code;
	int move_x;
	int move_y;
} CKeymapEntry;

void peach_pad_updateAll() {
	static const CKeymapEntry keymap_table[2][4] = {
		// p1 keymap
		{
			{SDL_SCANCODE_W, 0,-1},
			{SDL_SCANCODE_S, 0,1},
			{SDL_SCANCODE_A, -1,0},
			{SDL_SCANCODE_D, 1,0},
		},
		// p2 keymap
		{
			{SDL_SCANCODE_I, 0,-1},
			{SDL_SCANCODE_K, 0,1},
			{SDL_SCANCODE_J, -1,0},
			{SDL_SCANCODE_L, 1,0},
		},
	};
	auto work = peach_workGet();

	// get keyboard state
	const uint8_t* sdl_keystate = SDL_GetKeyboardState(NULL);
	for(int i=0; i<2; i++) {
		auto pad = &work->table_pad[i];
		int joy_x = 0;
		int joy_y = 0;

		for(int ji=0; ji<4; ji++) {
			const CKeymapEntry* keymap = &keymap_table[i][ji];
			if(sdl_keystate[keymap->code]) {
				joy_x += keymap->move_x;
				joy_y += keymap->move_y;
			}
		}

		pad->joy_x = joy_x;
		pad->joy_y = joy_y;
	}
}
void peach_padGet(CPeachPad* pad, size_t idx) {
	PEACH_ASSERT(pad,"peach_pad_get(): NULL pad");
	PEACH_ASSERT(idx < 2,"peach_pad_get(): idx out of range");

	auto work = peach_workGet();
	*pad = work->table_pad[idx];
}

