#include <peach.h>
#include <stdlib.h>
#include <stdio.h>
#include <SDL2/SDL_image.h>

// variable -----------------------------------------------------------------@/
CPeachWork* gPeachWork = NULL;

// function -----------------------------------------------------------------@/
void peach_init(int win_width, int win_height) {
	// initialize SDL -----------------------------------@/
	if( SDL_Init( SDL_INIT_VIDEO ) < 0 )
	{
		printf( "SDL could not initialize! SDL_Error: %s\n", SDL_GetError() );
		exit(-1);
	}
	IMG_Init(IMG_INIT_PNG);

	// initialize peachlib's workarea -------------------@/
	CPeachWork* work = calloc(sizeof(CPeachWork),1);
	gPeachWork = work;

	// initialize renderer ------------------------------@/
	static const bool vsync_enable = false;
	work->window_sizeX = win_width;
	work->window_sizeY = win_height;
	work->window_hnd = SDL_CreateWindow("peach",
		SDL_WINDOWPOS_UNDEFINED,
		SDL_WINDOWPOS_UNDEFINED,
		win_width,win_height,
		0
	);

	if(vsync_enable) {
		work->renderer_hnd = SDL_CreateRenderer(
			work->window_hnd,-1,
			SDL_RENDERER_ACCELERATED
				| SDL_RENDERER_PRESENTVSYNC
		);
	} else {
		work->renderer_hnd = SDL_CreateRenderer(
			work->window_hnd,-1,
			SDL_RENDERER_ACCELERATED
		);
	}
	work->renderer_vsync = vsync_enable;

	// initialize resources -----------------------------@/
	for(int i=0; i<PEACH_GRAPH_MAX; i++) {
		work->table_graph[i].basersrc = (CPeachResource){
			.alive = false,
			.id = i
		};
	}

	// initialize drawstate -----------------------------@/
	work->drawstate_idx = 0;
	peach_drawstate_reset();

	printf("peach: successfully initialized (workarea size: %.3fKB)\n",
		(double)(sizeof(CPeachWork)) / 1024.0
	);
}
void peach_close() {
	auto work = peach_workGet();
	PEACH_ASSERT(work,"closed peach before attempting to init");

	// closing leftover resources -----------------------@/
	for(int i=0; i<PEACH_GRAPH_MAX; i++) {
		auto gr = &work->table_graph[i];
		if(gr->basersrc.alive) {
			peach_graph_close(gr);
		}
	}

	SDL_Quit();
}
bool peach_processMessage() {
	bool do_quit = false;

	SDL_Event eve;
	while(SDL_PollEvent(&eve)) {
		switch(eve.type) {
			case SDL_QUIT: {
				do_quit = true;
				break;
			}
		}
	}

	return !do_quit;
}
void _peach_error(int line, const char* filename, const char* funcname, const char* message) {
	/*
		example output:
		peach: peach_close() error: closed peach before attempting to init.
		execution failed in source/peach/sys.c on line 66
	 */
	printf("peach: %s() error: %s\nexecution failed in %s on line %d\n",
		funcname,message,filename,line
	);
	exit(-1);
}

