#include <pgame.h>

// local function -----------------------------------------------------------@/
static void pgame_player_update(size_t idx) {
	PGame* work = pgame_workGet();
	CPlayer* player = pgame_playerGet(idx);

	if(!work->player_canMove) return;

	CPeachPad pad = {};
	peach_padGet(&pad,idx);

	// move depending on direction ----------------------@/
	static const int max_x = (FIELD_X - PADDLE_SIZEX) << 8;
	static const int max_y = (FIELD_Y - PADDLE_SIZEY) << 8;
	int px = player->pos.x;
	int py = player->pos.y;
	int shake = player->shake_timer;

	px += (pad.joy_x * PADDLE_SPEED) << 8;
	if(px < 0) px = 0;
	if(py < 0) py = 0;
	if(px >= max_x) px = max_x;
	if(py >= max_y) py = max_y;
	
	shake--;
	if(shake < 0) shake = 0;
	player->shake_timer = shake;
	player->pos = (vec2i) { px, py };
}
static void pgame_player_draw(size_t idx) {
	const auto player = pgame_playerGet(idx);
	const int playerid = player->playerid;
	const int shake = player->shake_timer;

	const CPeachColor paddlecolor_table[PLAYER_MAX] = {
		peach_colorGetRGB(125,55,72),    // red
		peach_colorGetRGB(129,147,170),  // blue
	};

	// Shake offset should multiply by -1 if shake_timer
	// is odd, or 1 if even.
	int shake_offset = shake;
	shake_offset *= (((shake/2)&1) ? -1 : 1);
	int px = player->pos.x >> 8;
	int py = player->pos.y >> 8;
	px += shake_offset;

	peach_draw_rect(paddlecolor_table[playerid],
		px,py,
		PADDLE_SIZEX,
		PADDLE_SIZEY
	);

	// brighten paddle, if it's shaking -----------------@/
	peach_drawstate_push();
	peach_drawstate_blendSet(PEACH_DRAWBLEND_ADD);
	float alpha = (float)(shake) / (float)(PLAYER_SHAKEDURATION);
	int bar_bright = (int)(50.0f * alpha);
	CPeachColor bar_brightClr = peach_colorGetRGB(bar_bright,bar_bright,bar_bright);

	peach_draw_rect(bar_brightClr,
		px,py,
		PADDLE_SIZEX,
		PADDLE_SIZEY
	);
	peach_drawstate_pop();
}

// function -----------------------------------------------------------------@/
void pgame_player_setup() {
	auto work = pgame_workGet();
	for(int i=0; i<PLAYER_MAX; i++) {
		work->players[i] = (CPlayer){
			.score = 0,
			.pos = { (FIELD_X/2 - (PADDLE_SIZEX/2)) << 8, 0 },
			.playerid = i,
			.shake_timer = 0
		};
	}

	work->players[0].pos.y = (FIELD_Y - PADDLE_SIZEY) << 8;
	work->players[1].pos.y = 0;
}
void pgame_player_updateAll() {
	for(int i=0; i<PLAYER_MAX; i++) {
		pgame_player_update(i);
	}
}
void pgame_player_drawAll() {
	for(int i=0; i<PLAYER_MAX; i++) {
		pgame_player_draw(i);
	}
}

